/* Created on 07.09.2006 */

package de.memowe.sbc.kernel;

/**
 * Error messages for SBC.
 * 
 * @author Mirko Westermeier <mail@memowe.de>
 */
public class Errors {
        
    public static final int NO_QUOTE_END      = 0;
    public static final int NO_EMPHASIS_END   = 1;
    public static final int NO_STRONG_END     = 2;
    public static final int NO_HYPERLINK_END  = 3;
    public static final int NO_IMAGE_END      = 4;
    public static final int FORBIDDEN_URL     = 5;
    public static final int UNKNOWN_TOKEN     = 6;
    
    private static String eget(int e, int language) {
        String msg = "";

        switch (e) {
        case NO_QUOTE_END:
            msg += language == Languages.GERMAN ? "Kein Zitatende-Zeichen ']'"
                    : "No quote end tag ']'";
            break;
        case NO_EMPHASIS_END:
            msg += language == Languages.GERMAN ? "Kein Betonungs-Endezeichen '*'"
                    : "No emphasis end tag '*'";
            break;
        case NO_STRONG_END:
            msg += language == Languages.GERMAN ? "Kein Hervorhebungs-Endezeichen '_'"
                    : "No strong end tag '_'";
            break;
        case NO_HYPERLINK_END:
            msg += language == Languages.GERMAN ? "Kein Hyperlink-Endezeichen '>'"
                    : "No hyperlink end tag '>'";
            break;
        case NO_IMAGE_END:
            msg += language == Languages.GERMAN ? "Kein Bild-Endezeichen '}'"
                    : "No image end tag '}'";
            break;
        case FORBIDDEN_URL:
            msg += language == Languages.GERMAN ? "Verbotener URL" : "Forbidden URL";
            break;
        case UNKNOWN_TOKEN:
            msg += language == Languages.GERMAN ? "Unbekanntes Zeichen"
                    : "Unknown token";
            break;
        }

        return msg;
    }
    
    /**
     * Returns an error message.
     * 
     * @param e name
     * @param line line number
     * @param language language of the error message
     * @return the error message
     */
    public static String get(int e, int line, int language) {
        return
            eget(e, language)
            + (language == Languages.GERMAN ? " um logische Zeile " : " around logical line ")
            + line;
    }
    
    /**
     * Returns an error message with an argument.
     * 
     * @param e name
     * @param arg argument
     * @param line line number
     * @param language language of the error message
     * @return the error message
     */
    public static String get(int e, String arg, int line, int language) {
        return
            eget(e, language)
            + " " + arg + " "
            + (language == Languages.GERMAN ? " um logische Zeile " : " around logical line ")
            + line;
    }
    
}
