/* Created on 14.09.2006 */

package de.memowe.sbc.kernel;

import java.util.regex.Pattern;

/**
 * Regex tokens for SBC.
 * 
 * @author Mirko Westermeier <mail@memowe.de>
 */
public class Tokens {

    public static final Pattern EMPHASIS        = Pattern.compile("^(?:\\*)");
    public static final Pattern STRONG          = Pattern.compile("^(?:_)");
    public static final Pattern HYPERLINK_START = Pattern.compile("^(?:<(https?://[^ >\n]+) *)");
    public static final Pattern HYPERLINK_END   = Pattern.compile("^(?:>)");
    public static final Pattern IMAGE_START     = Pattern.compile("^(?:\\{(https?://[^ }\n]+) *)");
    public static final Pattern IMAGE_END       = Pattern.compile("^(?:\\})");
    public static final Pattern QUOTE_START     = Pattern.compile("^(?:\n+\\[\n?)");
    public static final Pattern QUOTE_END       = Pattern.compile("^(?:\\] *\n+)");
    public static final Pattern QUOTE_END_CITE  = Pattern.compile("^(?:\\] *)");
    public static final Pattern UL_BULLET       = Pattern.compile("^(?:\n+- *)");
    public static final Pattern OL_BULLET       = Pattern.compile("^(?:\n+# *)");
    public static final Pattern LINEBREAK       = Pattern.compile("^(?:\n+)");
    public static final Pattern PLAIN           = Pattern.compile("^(?:((?:[^\\*_<>\\{\\}\\[\\]#\\\\\n]+|\\\\[\\*_<>\\{\\}\\[\\]#\\\\\n])*))");
    
}
