/* Created on 23.09.2006 */

package test;

import de.memowe.sbc.SBCParser;

/**
 * Test class for basic sbc translation.
 * 
 * @author Mirko Westermeier <mail@memowe.de>
 */
public class TestBasic {
    
    public static void main(String[] args) {

        String[][] tests = {
                { "plain text", "foo bar baz", "<p>foo bar baz</p>\n" },
                { "two paragraphs", "foo\nbar", "<p>foo</p>\n<p>bar</p>\n" },
                { "emphasis", "*foo*", "<p><em>foo</em></p>\n" },
                { "strong emphasis", "_foo_", "<p><strong>foo</strong></p>\n" },
                { "hyperlink", "<http://foo>",
                    "<p><a href=\"http://foo\">http://foo</a></p>\n"
                },
                { "hyperlink with text", "<http://foo bar>",
                    "<p><a href=\"http://foo\">bar</a></p>\n"
                },
                { "image", "{http://foo}",
                    "<p><img src=\"http://foo\" alt=\"\"></p>\n"
                },
                { "image with alt text", "{http://foo bar}",
                    "<p><img src=\"http://foo\" alt=\"bar\"></p>\n"
                },
                { "unordered list", "- foo\n- bar",
                    "<ul>\n\t<li>foo</li>\n\t<li>bar</li>\n</ul>\n"
                },
                { "ordered list", "# foo\n# bar",
                    "<ol>\n\t<li>foo</li>\n\t<li>bar</li>\n</ol>\n"
                },
                { "quote", "[foo]",
                    "<div class=\"quote\"><blockquote>\n<p>foo</p>\n"
                    + "</blockquote></div>\n"
                },
                { "quote with cite", "[foo]bar",
                    "<div class=\"quote\"><cite>bar</cite><blockquote>\n"
                    + "<p>foo</p>\n</blockquote></div>\n"
                }
        };
        
        int ok = 0;
        
        SBCParser parser = new SBCParser();
        parser.setImageSupport(true);
        
        for (int i = 0; i < tests.length; i++) {
            System.out.print(tests[i][0] + "... ");
            String out = parser.sbc(tests[i][1]);
            if (tests[i][2].equals(out)) {
                System.out.println("ok.");
                ok++;
            } else {
                System.out.println("not ok: " + out);
            }
            while (parser.hasMoreErrors()) {
                System.out.println("Error: " + parser.nextError());
            }
        }
        
        System.out.println(ok + " tests successful of " + tests.length);

    }

}
