/* Created on 23.09.2006 */

package test;

import de.memowe.sbc.SBCParser;

/**
 * Test class for inline sbc translation.
 * 
 * @author Mirko Westermeier <mail@memowe.de>
 */
public class TestInline {
    
    public static void main(String[] args) {

        String[][] tests = {
                { "plain text", "foo bar baz", "foo bar baz" },
                { "plain whitespace", "\t   ", "" },
                { "plain special char \"", "\"", "&quot;" },
                { "plain special char *", "\\*", "*" },
                { "plain special char _", "\\_", "_" },
                { "plain special chars []", "\\[\\]", "[]" },
                { "plain special chars {}", "\\{\\}", "{}" },
                { "plain special chars <>", "\\<\\>", "&lt;&gt;" },
                { "emphasis", "*foo*", "<em>foo</em>" },
                { "strong emphasis", "_foo_", "<strong>foo</strong>" },
                { "hyperlink", "<http://foo>",
                    "<a href=\"http://foo\">http://foo</a>"
                },
                { "hyperlink with text", "<http://foo bar>",
                    "<a href=\"http://foo\">bar</a>"
                },
                { "image", "{http://foo}",
                    "<img src=\"http://foo\" alt=\"\">"
                },
                { "image with alt text", "{http://foo bar}",
                    "<img src=\"http://foo\" alt=\"bar\">"
                }
        };
        
        int ok = 0;
        
        SBCParser parser = new SBCParser();
        parser.setImageSupport(true);
        
        for (int i = 0; i < tests.length; i++) {
            System.out.print(tests[i][0] + "... ");
            String out = parser.sbcInline(tests[i][1]);
            if (tests[i][2].equals(out)) {
                System.out.println("ok.");
                ok++;
            } else {
                System.out.println("not ok: " + out);
            }
            while (parser.hasMoreErrors()) {
                System.out.println("Error: " + parser.nextError());
            }
        }
        
        System.out.println(ok + " tests successful of " + tests.length);

    }

}
