/* Created on 23.09.2006 */

package test;

import de.memowe.sbc.SBCParser;

/**
 * Test class for quirks sbc translation.
 * 
 * @author Mirko Westermeier <mail@memowe.de>
 */
public class TestQuirks {
    
    public static void main(String[] args) {

        String[][] tests = {
                { "half emphasis", "foo*bar", "<p>foo<em>bar</em></p>\n" },
                { "half strong emphasis", "foo_bar",
                    "<p>foo<strong>bar</strong></p>\n"
                },
                { "half hyperlink", "foo<http://foo",
                    "<p>foo<a href=\"http://foo\">http://foo</a></p>\n"
                },
                { "half hyperlink with text", "foo<http://foo bar",
                    "<p>foo<a href=\"http://foo\">bar</a></p>\n"
                },
                { "wrong nested inline elements  I", "_foo*bar_baz*yada",
                    "<p><strong>foo<em>bar</em></strong>baz<em>yada</em></p>\n"
                },
                { "wrong nested inline elements II", "<http://foo foo_bar>",
                    "<p><a href=\"http://foo\">foo<strong>bar</strong></a></p>\n"
                }
        };
        
        int ok = 0;
        
        SBCParser parser = new SBCParser();
        parser.setImageSupport(true);
        
        for (int i = 0; i < tests.length; i++) {
            System.out.print(tests[i][0] + "... ");
            String out = parser.sbc(tests[i][1]);
            if (tests[i][2].equals(out)) {
                System.out.println("ok.");
                ok++;
            } else {
                System.out.println("not ok: " + out);
            }
            // no error checks. there WILL BE some.
        }
        
        System.out.println(ok + " tests successful of " + tests.length);

    }

}
